/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectors.restconnect.commons.api.annotation;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.PARAMETER;
import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Annotation used to mark that the annotated element has been manually modified since Rest Connect
 * originally generated it.
 * <p>
 * It's very important to mark all manually modified elements so that during the upgrade process, Rest Connect can
 * try to merge the newly generated code with the customized one, or at least generate a diff if automatic merge is not
 * possible.
 * <p>
 * This annotation can be applied to classes, fields, parameters or methods. Uses of this annotation should be as
 * granular and specific as possible.
 *
 * @since 1.0
 */
@Target({TYPE, FIELD, PARAMETER, METHOD})
@Retention(RUNTIME)
@Documented
public @interface Customized {

}
