/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectors.restconnect.commons.api.connection;

import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;

/**
 * Base class for connection providers which use basic authentication
 *
 * @since 1.0
 */
public abstract class BasicAuthenticationConnectionProvider extends BaseConnectionProvider {

  /**
   * The username to authenticate the requests
   */
  @Parameter
  @Optional
  @Summary("The username to authenticate the requests")
  protected String username;

  /**
   * The password to authenticate the requests
   */
  @Parameter
  @Optional
  @Summary("The password to authenticate the requests")
  @Password
  protected String password;

  @Override
  protected HttpAuthentication buildAuthentication() {
    return HttpAuthentication.basic(username, password).build();
  }
}
