/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectors.restconnect.commons.api.connection.oauth;

import org.mule.connectors.restconnect.commons.api.connection.BaseConnectionProvider;
import org.mule.connectors.restconnect.commons.api.connection.RestConnection;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.connectivity.oauth.ClientCredentialsState;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;

/**
 * Base class for Connection Providers that authenticate using OAuth with the Authorization Code Grant Type
 *
 * @since 1.0
 */
public abstract class BaseClientCredentialsConnectionProvider extends BaseConnectionProvider {

  private ClientCredentialsState oauthState;


  @Override
  protected RestConnection createConnection(HttpClient httpClient,
                                            HttpAuthentication authentication,
                                            MultiMap<String, String> defaultQueryParams,
                                            MultiMap<String, String> defaultHeaders) {
    return new OAuthRestConnection(getBaseUri(),
                                   getConfigName(),
                                   httpClient,
                                   authentication,
                                   defaultQueryParams,
                                   defaultHeaders,
                                   getOAuthState(),
                                   "default");
  }

  protected ClientCredentialsState getOAuthState() {
    return oauthState;
  }
}
