/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectors.restconnect.commons.api.datasense.resolver.input;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;

/**
 * Base class for a {@link PrimitiveInputMetadataResolver} which resolves a file type.
 * This is only meant to be used in generic connectors generated using Rest Connect.
 * For hand-made custom connectors a Java Type can be used instead.
 *
 * @since 1.0
 */
public abstract class FileInputMetadataResolver extends PrimitiveInputMetadataResolver {

  protected abstract MetadataFormat getFormat();

  @Override
  public MetadataType getStaticMetadata() {
    return BaseTypeBuilder.create(getFormat()).stringType().build();
  }
}
