/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectors.restconnect.commons.api.datasense.resolver.input;

import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.resolving.InputTypeResolver;

/**
 * Base class for {@link InputTypeResolver} implementations that dynamically load a schema.
 *
 * @since 1.0
 */
public abstract class SchemaInputMetadataResolver implements InputTypeResolver<Object> {

  @Override
  public String getResolverName() {
    return getClass().getName();
  }

  /**
   * Absolute path to the schema between the context of the owning connector. This path will be read
   * using the {@link Class#getResourceAsStream(String)} method
   *
   * @return the schema path inside the connector
   */
  protected abstract String getSchemaPath();

  /**
   * Parses the given {@code schema} and transforms it to a {@link MetadataType}
   * @param schema the schema to parse
   * @return a {@link MetadataType}
   */
  protected abstract MetadataType loadSchema(String schema);

  @Override
  public MetadataType getInputMetadata(MetadataContext metadataContext, Object keyLess) {
    return loadSchema(getSchemaPath());
  }
}
