/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectors.restconnect.commons.api.datasense.resolver.input;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.metadata.resolving.InputStaticTypeResolver;

/**
 * Base class for a {@link InputStaticTypeResolver} which resolves a type of a known format but unknown
 * schema.
 *
 * @since 1.0
 */
public abstract class UnspecifiedInputMetadataResolver extends InputStaticTypeResolver {

  @Override
  public String getResolverName() {
    return getClass().getName();
  }

  @Override
  public MetadataType getStaticMetadata() {
    return BaseTypeBuilder.create(getFormat()).objectType().build();
  }

  protected abstract MetadataFormat getFormat();
}
