/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectors.restconnect.commons.api.datasense.resolver.output;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;

/**
 * Base class for {@link OutputTypeResolver}  which resolves a file type.
 * This is only meant to be used in generic connectors generated using Rest Connect.
 * For hand-made custom connectors a Java Type can be used instead.
 *
 * @since 1.0
 */
public abstract class FileOutputMetadataResolver implements OutputTypeResolver<Object> {

  protected abstract MetadataFormat getFormat();

  @Override
  public MetadataType getOutputType(MetadataContext metadataContext, Object keyLess) {
    return BaseTypeBuilder.create(getFormat()).stringType().build();
  }
}
