/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectors.restconnect.commons.api.datasense.resolver.output;

import static org.mule.connectors.restconnect.commons.internal.util.RestConnectUtils.readSchema;
import static org.mule.metadata.api.builder.BaseTypeBuilder.create;
import static org.mule.metadata.api.model.MetadataFormat.JAVA;

import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.metadata.resolving.OutputStaticTypeResolver;


/**
 * An {@link OutputStaticTypeResolver} to use in paging operations. This resolver takes the path to a schema
 * shipped with the connector and generates an {@link ArrayType} which target type is generated by parsing that schema.
 *
 * @since 1.0
 */
public abstract class PagingMetadataResolver extends OutputStaticTypeResolver {

  /**
   * Absolute path to the schema between the context of the owning connector. This path will be read
   * using the {@link Class#getResourceAsStream(String)} method
   *
   * @return the schema path inside the connector
   */
  protected abstract String getSchemaPath();

  /**
   * Parses the given {@code schema} and transforms it to a {@link MetadataType}
   * @param schema the schema to parse
   * @return a {@link MetadataType}
   */
  protected abstract MetadataType loadSchema(String schema);

  @Override
  public MetadataType getStaticMetadata() {
    return create(JAVA).arrayType().of(loadSchema(getSchemaPath())).build();
  }
}
