/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectors.restconnect.commons.api.datasense.resolver.output;

import static org.mule.metadata.api.model.MetadataFormat.JAVA;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;

/**
 * Base class for {@link OutputTypeResolver}  which resolves a java string type.
 * This type resolver exists in order for the string type payloads to be streamed.
 *
 * @since 1.0
 */
public abstract class StringOutputMetadataResolver implements OutputTypeResolver<Object> {

  @Override
  public MetadataType getOutputType(MetadataContext metadataContext, Object keyLess) {
    return BaseTypeBuilder.create(JAVA).stringType().build();
  }

}
