/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectors.restconnect.commons.api.request;

import static java.util.Objects.hash;
import static org.mule.runtime.api.meta.ExpressionSupport.NOT_SUPPORTED;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Parameter;

import java.util.Objects;

/**
 * Base class for object parameters that represent a key-value pair. This is useful for cases in which
 * map like structures are to be parameterized without the ability to support expressions
 *
 * @since 1.0
 */
public abstract class KeyValue {

  /**
   * The parameter key
   */
  @Parameter
  @Expression(NOT_SUPPORTED)
  private String key;

  /**
   * The parameter value
   */
  @Parameter
  @Expression(NOT_SUPPORTED)
  private String value;

  public String getKey() {
    return key;
  }

  public String getValue() {
    return value;
  }

  @Override
  public boolean equals(Object obj) {
    if (getClass().isInstance(obj)) {
      KeyValue other = (KeyValue) obj;
      return Objects.equals(key, other.key) && Objects.equals(value, other.value);
    }

    return false;
  }

  @Override
  public int hashCode() {
    return hash(key, value);
  }
}
