/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectors.restconnect.commons.internal.multipart;

import org.mule.runtime.api.metadata.TypedValue;

import java.io.InputStream;

/**
 * A {@link Part} that carries a file attachment
 *
 * @since 1.0
 */
public class FilePart extends Part {

  private final String filename;

  public FilePart(String name, String filename, TypedValue<InputStream> content) {
    super(name, content);
    this.filename = filename;
  }

  public String getFilename() {
    return filename;
  }

  @Override
  public void accept(PartVisitor visitor) {
    visitor.visit(this);
  }
}
