/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectors.restconnect.commons.internal.util;

import static java.util.regex.Pattern.compile;

import java.util.regex.Pattern;

public class DwUtils {

  private DwUtils() {}

  private final static Pattern dwInvalidChars = compile("[^a-zA-Z0-9_]");

  public static String getDwIdentifier(String name) {
    while (dwInvalidChars.matcher(name).find()) {
      name = dwInvalidChars.matcher(name).replaceAll("_");
    }

    return "dw" + name;
  }
}
