/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectors.restconnect.commons.api.connection;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.mule.connectors.restconnect.commons.api.connection.DefaultRestConnection;
import org.mule.connectors.restconnect.commons.api.connection.RestConnection;
import org.mule.connectors.restconnect.commons.api.connection.TlsParameterGroup;
import org.mule.connectors.restconnect.commons.api.connection.validation.ConnectionValidationSettings;
import org.mule.connectors.restconnect.commons.api.proxy.HttpProxyConfig;
import org.mule.connectors.restconnect.commons.api.request.KeyValue;
import org.mule.connectors.restconnect.commons.api.request.QueryParam;
import org.mule.connectors.restconnect.commons.api.request.RequestHeader;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.tls.TlsContextFactoryBuilder;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.runtime.http.api.tcp.TcpClientSocketProperties;
import org.mule.runtime.http.api.tcp.TcpClientSocketPropertiesBuilder;

public abstract class BaseConnectionProvider
implements CachedConnectionProvider<RestConnection>,
Initialisable,
Startable,
Stoppable {
    static final String CLIENT_NAME_PATTERN = "rest.connect.%s";
    @RefName
    private String configName;
    @Inject
    private HttpService httpService;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @NullSafe
    @Placement(tab="Advanced", order=1)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private List<RequestHeader> defaultHeaders;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @NullSafe
    @DisplayName(value="Query Parameters")
    @Placement(tab="Advanced", order=2)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private List<QueryParam> defaultQueryParams;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="30")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="The timeout for establishing connections to the remote service")
    @Placement(tab="Advanced", order=3)
    private Integer connectionTimeout;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="SECONDS")
    @Placement(tab="Advanced", order=4)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="A time unit which qualifies the Connection Timeout")
    private TimeUnit connectionTimeoutUnit = TimeUnit.SECONDS;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="true")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=5)
    @Summary(value="If false, each connection will be closed after the first request is completed.")
    private boolean usePersistentConnections = true;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="-1")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=6)
    @Summary(value="The maximum number of outbound connections that will be kept open at the same time")
    private Integer maxConnections;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="30")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=7)
    @Summary(value="A timeout for how long a connection can remain idle before it is closed")
    private Integer connectionIdleTimeout;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="SECONDS")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=8)
    @Summary(value="A time unit which qualifies the connection Idle Timeout")
    private TimeUnit connectionIdleTimeoutUnit = TimeUnit.SECONDS;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @Summary(value="Reusable configuration element for outbound connections through a proxy")
    @Placement(tab="Proxy")
    private HttpProxyConfig proxyConfig;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="false")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=9)
    @Summary(value="Whether or not received responses should be streamed")
    private boolean streamResponse = false;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="-1")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=10)
    @Summary(value="The space in bytes for the buffer where the HTTP response will be stored.")
    private int responseBufferSize;
    private TlsContextFactoryBuilder defaultTlsContextFactoryBuilder = TlsContextFactory.builder();
    private TlsContextFactory effectiveTlsContext = null;
    private HttpAuthentication authentication;
    private HttpClient httpClient;

    public abstract String getBaseUri();

    public final void initialise() throws InitialisationException {
        this.initialiseTls();
        this.verifyConnectionsParameters();
        this.authentication = this.buildAuthentication();
        if (this.authentication != null) {
            LifecycleUtils.initialiseIfNeeded((Object)this.authentication);
        }
    }

    public void start() {
        this.startHttpClient();
    }

    public void stop() {
        this.httpClient.stop();
    }

    private void initialiseTls() throws InitialisationException {
        TlsParameterGroup tls = this.getTlsConfig().orElse(null);
        if (tls == null) {
            return;
        }
        HttpConstants.Protocol protocol = tls.getProtocol();
        TlsContextFactory tlsContext = tls.getTlsContext();
        if (protocol.equals((Object)HttpConstants.Protocol.HTTP) && tlsContext != null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"TlsContext cannot be configured with protocol HTTP, when using tls:context you must set attribute protocol=\"HTTPS\""), (Initialisable)this);
        }
        if (protocol.equals((Object)HttpConstants.Protocol.HTTPS) && tlsContext == null) {
            LifecycleUtils.initialiseIfNeeded((Object)this.defaultTlsContextFactoryBuilder);
            tlsContext = this.defaultTlsContextFactoryBuilder.buildDefault();
        }
        if (tlsContext != null) {
            LifecycleUtils.initialiseIfNeeded((Object)tlsContext);
            this.effectiveTlsContext = tlsContext;
        }
    }

    public final RestConnection connect() throws ConnectionException {
        try {
            return this.createConnection(this.httpClient, this.authentication, this.toMultiMap(this.defaultQueryParams), this.toMultiMap(this.defaultHeaders));
        }
        catch (Exception e) {
            throw new ConnectionException("Could not create connection", (Throwable)e);
        }
    }

    private void startHttpClient() {
        HttpClientConfiguration.Builder configuration = new HttpClientConfiguration.Builder().setTlsContextFactory(this.effectiveTlsContext).setProxyConfig((ProxyConfig)this.proxyConfig).setMaxConnections(this.maxConnections.intValue()).setUsePersistentConnections(this.usePersistentConnections).setConnectionIdleTimeout(this.asMillis(this.connectionIdleTimeout, this.connectionTimeoutUnit)).setStreaming(this.streamResponse).setResponseBufferSize(this.responseBufferSize).setName(String.format(CLIENT_NAME_PATTERN, this.configName));
        this.configureTcpSocket(configuration);
        this.configureClient(configuration);
        this.httpClient = this.httpService.getClientFactory().create(configuration.build());
        this.httpClient.start();
    }

    private MultiMap<String, String> toMultiMap(Collection<? extends KeyValue> keyValues) {
        MultiMap multiMap = new MultiMap();
        if (keyValues != null) {
            keyValues.forEach(kv -> {
                String cfr_ignored_0 = (String)multiMap.put((Object)kv.getKey(), (Object)kv.getValue());
            });
        }
        return multiMap;
    }

    protected RestConnection createConnection(HttpClient httpClient, HttpAuthentication authentication, MultiMap<String, String> defaultQueryParams, MultiMap<String, String> defaultHeaders) {
        return new DefaultRestConnection(this.getBaseUri(), this.getConfigName(), httpClient, authentication, defaultQueryParams, defaultHeaders);
    }

    protected HttpAuthentication buildAuthentication() {
        return null;
    }

    public final void disconnect(RestConnection restConnection) {
        try {
            restConnection.stop();
        }
        finally {
            this.effectiveTlsContext = null;
        }
    }

    public ConnectionValidationResult validate(RestConnection restConnection) {
        return ConnectionValidationResult.success();
    }

    protected ConnectionValidationResult validate(RestConnection restConnection, ConnectionValidationSettings settings) {
        return restConnection.validate(settings, this.asMillis(this.connectionTimeout, this.connectionTimeoutUnit));
    }

    protected void configureClient(HttpClientConfiguration.Builder httpConfiguration) {
    }

    protected Optional<TlsParameterGroup> getTlsConfig() {
        return Optional.empty();
    }

    private void verifyConnectionsParameters() throws InitialisationException {
        if (this.getMaxConnections() == 0 || this.getMaxConnections() < -1) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"The maxConnections parameter only allows positive values or -1 for unlimited concurrent connections."), (Initialisable)this);
        }
        if (this.isUsePersistentConnections()) {
            this.connectionIdleTimeout = 0;
        }
    }

    private void configureTcpSocket(HttpClientConfiguration.Builder configuration) {
        TcpClientSocketPropertiesBuilder socketProperties = TcpClientSocketProperties.builder();
        if (this.connectionTimeout != null) {
            socketProperties.connectionTimeout(Integer.valueOf(this.asMillis(this.connectionTimeout, this.connectionTimeoutUnit)));
        }
        configuration.setClientSocketProperties(socketProperties.build());
    }

    private int asMillis(Integer value, TimeUnit unit) {
        if (value == null || value == -1) {
            return -1;
        }
        return Long.valueOf(unit.toMillis(value.intValue())).intValue();
    }

    protected String getConfigName() {
        return this.configName;
    }

    public List<RequestHeader> getDefaultHeaders() {
        return this.defaultHeaders;
    }

    public List<QueryParam> getDefaultQueryParams() {
        return this.defaultQueryParams;
    }

    protected Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    protected TimeUnit getConnectionTimeoutUnit() {
        return this.connectionTimeoutUnit;
    }

    protected boolean isUsePersistentConnections() {
        return this.usePersistentConnections;
    }

    protected Integer getMaxConnections() {
        return this.maxConnections;
    }

    protected Integer getConnectionIdleTimeout() {
        return this.connectionIdleTimeout;
    }

    protected TimeUnit getConnectionIdleTimeoutUnit() {
        return this.connectionIdleTimeoutUnit;
    }

    protected HttpProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    protected boolean isStreamResponse() {
        return this.streamResponse;
    }

    protected int getResponseBufferSize() {
        return this.responseBufferSize;
    }
}

