/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.connectors.restconnect.commons.api.operation;

import org.mule.runtime.api.util.MultiMap;

/**
 * Groups general parameters for operations
 *
 * @since 1.0
 */
public interface RequestParameters {

  /**
   * @return a {@link MultiMap} containing custom query params to be sent in the HTTP request
   */
  MultiMap<String, String> getCustomQueryParams();

  /**
   * @return a {@link MultiMap} containing custom headers to be sent in the HTTP request
   */
  MultiMap<String, String> getCustomHeaders();

}
