/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.connectors.restconnect.commons.api.request;

import static java.util.Objects.hash;
import static org.mule.runtime.api.meta.ExpressionSupport.NOT_SUPPORTED;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Parameter;

import java.util.Objects;

/**
 * Base class for object parameters that represent a key-value pair. This is useful for cases in which
 * map like structures are to be parameterized without the ability to support expressions
 *
 * @since 1.0
 */
public abstract class KeyValue {

  /**
   * The parameter key
   */
  @Parameter
  @Expression(NOT_SUPPORTED)
  private String key;

  /**
   * The parameter value
   */
  @Parameter
  @Expression(NOT_SUPPORTED)
  private String value;

  public String getKey() {
    return key;
  }

  public String getValue() {
    return value;
  }

  @Override
  public boolean equals(Object obj) {
    if (getClass().isInstance(obj)) {
      KeyValue other = (KeyValue) obj;
      return Objects.equals(key, other.key) && Objects.equals(value, other.value);
    }

    return false;
  }

  @Override
  public int hashCode() {
    return hash(key, value);
  }
}
