/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectors.restconnect.commons.api.error;

import java.util.Optional;
import java.util.function.Function;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.error.MuleErrors;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;

public enum RestConnectError implements ErrorTypeDefinition<RestConnectError>
{
    CONNECTIVITY((ErrorTypeDefinition<?>)MuleErrors.CONNECTIVITY),
    CLIENT_ERROR,
    TIMEOUT(CLIENT_ERROR),
    UNAUTHORIZED(CLIENT_ERROR),
    NOT_FOUND(CLIENT_ERROR),
    TOO_MANY_REQUESTS(CLIENT_ERROR),
    BAD_REQUEST(CLIENT_ERROR),
    UNSUPPORTED_MEDIA_TYPE(CLIENT_ERROR, request -> "media type " + request.getHeaderValue("Content-Type") + " not supported"),
    NOT_ACCEPTABLE,
    SERVER_ERROR,
    INTERNAL_SERVER_ERROR(SERVER_ERROR),
    SERVICE_UNAVAILABLE(SERVER_ERROR);

    private ErrorTypeDefinition<?> parentErrorType;
    private Function<HttpRequest, String> errorMessageFunction;

    private RestConnectError() {
        String message = this.name().replace("_", " ").toLowerCase();
        this.errorMessageFunction = httpRequest -> message;
    }

    private RestConnectError(ErrorTypeDefinition<?> parentErrorType) {
        this();
        this.parentErrorType = parentErrorType;
    }

    private RestConnectError(ErrorTypeDefinition<?> parentErrorType, Function<HttpRequest, String> errorMessageFunction) {
        this.parentErrorType = parentErrorType;
        this.errorMessageFunction = errorMessageFunction;
    }

    public Optional<ErrorTypeDefinition<? extends Enum<?>>> getParent() {
        return Optional.ofNullable(this.parentErrorType);
    }

    public static Optional<RestConnectError> getErrorByCode(int statusCode) {
        RestConnectError error = null;
        HttpConstants.HttpStatus status = HttpConstants.HttpStatus.getStatusByCode((int)statusCode);
        if (status != null) {
            try {
                error = RestConnectError.valueOf(status.name());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (error == null) {
            if (statusCode >= 400 && statusCode < 500) {
                error = CLIENT_ERROR;
            } else if (statusCode >= 500) {
                error = SERVER_ERROR;
            }
        }
        return Optional.ofNullable(error);
    }

    public static Optional<HttpConstants.HttpStatus> getHttpStatus(RestConnectError error) {
        HttpConstants.HttpStatus result = null;
        for (HttpConstants.HttpStatus status : HttpConstants.HttpStatus.values()) {
            if (!error.name().equals(status.name())) continue;
            result = status;
        }
        return Optional.ofNullable(result);
    }

    public String getErrorMessage(HttpRequest request) {
        return this.errorMessageFunction.apply(request);
    }
}

