/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.connectors.restconnect.commons.api.datasense.resolver;

import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.json.api.JsonTypeLoader;

/**
 * Specialization of {@link PagingTypeResolver} for json schemas
 *
 * @since 1.0
 */
public abstract class PagingJsonTypeResolver extends PagingTypeResolver {

  @Override
  protected MetadataType loadSchema(String schema) {
    return new JsonTypeLoader(schema).load(null).get();
  }
}
