/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.connectors.restconnect.commons.api.datasense.resolver;

import static org.mule.metadata.xml.api.SchemaCollector.getInstance;

import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.xml.api.XmlTypeLoader;

import java.io.ByteArrayInputStream;

/**
 * {@link SchemaInputTypeResolver} that loads an XML schema
 *
 * @since 1.0
 */
public abstract class XmlInputTypeResolver extends SchemaInputTypeResolver {

  @Override
  protected MetadataType loadSchema(String schema) {
    return new XmlTypeLoader(getInstance().addSchema(getSchemaPath(), new ByteArrayInputStream(schema.getBytes())))
        .load(getQName()).get();
  }

  /**
   * @return the QName for the loaded XML type
   */
  protected abstract String getQName();
}
