/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.connectors.restconnect.commons.api.operation;

import static org.mule.runtime.api.util.MultiMap.emptyMultiMap;
import static org.mule.runtime.extension.api.annotation.param.display.Placement.ADVANCED_TAB;

import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;

/**
 * A parameter group that contains general parameters for operations which do not accept an HTTP entity
 *
 * @since 1.0
 */
public class EntityRequestParameters implements RequestParameters {

  /**
   * Custom Query Parameters the request should include. The ones specified here will be added to the default ones
   * specified in the config. The ones specified here will be added to the default ones specified in the config.
   */
  @Parameter
  @Optional
  @Content(primary = false)
  @DisplayName("Custom Query Parameters")
  @Placement(tab = ADVANCED_TAB, order = 1)
  private MultiMap<String, String> customQueryParams = emptyMultiMap();

  /**
   * Custom Headers the request should include. The ones specified here will be added to the default ones
   * specified in the config. The ones specified here will be added to the default ones specified in the config.
   */
  @Parameter
  @Optional
  @Content
  @DisplayName("Custom Headers")
  @Placement(tab = ADVANCED_TAB, order = 2)
  protected MultiMap<String, String> customHeaders = emptyMultiMap();

  @Override
  public MultiMap<String, String> getCustomHeaders() {
    return customHeaders;
  }

  @Override
  public MultiMap<String, String> getCustomQueryParams() {
    return customQueryParams;
  }
}
