/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectors.restconnect.commons.api.operation.paging;

import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.mule.connectors.restconnect.commons.api.connection.RestConnection;
import org.mule.connectors.restconnect.commons.api.operation.HttpResponseAttributes;
import org.mule.connectors.restconnect.commons.internal.util.RestConnectUtils;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RestPagingProvider
implements PagingProvider<RestConnection, TypedValue<String>> {
    private static final DataType INTEGER_DATA_TYPE = DataType.fromType(Integer.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(RestPagingProvider.class);
    protected final ExpressionLanguage expressionLanguage;
    protected final int responseTimeout;
    protected final MediaType mediaType;
    protected final String encoding;
    private final Function<RestConnection, HttpRequestBuilder> requestFactory;
    private final StreamingHelper streamingHelper;
    private final String payloadExpression;
    private final DataType dataType;
    private int pageIndex = -1;
    private boolean stopPaging = false;

    public RestPagingProvider(Function<RestConnection, HttpRequestBuilder> requestFactory, ExpressionLanguage expressionLanguage, StreamingHelper streamingHelper, String payloadExpression, MediaType mediaType, String encoding, int responseTimeout) {
        this.requestFactory = requestFactory;
        this.streamingHelper = streamingHelper;
        this.expressionLanguage = expressionLanguage;
        this.responseTimeout = responseTimeout;
        this.payloadExpression = payloadExpression;
        this.mediaType = mediaType;
        this.encoding = encoding;
        this.dataType = DataType.builder().type(String.class).mediaType(mediaType).charset(encoding).build();
    }

    protected abstract void configureRequest(HttpRequestBuilder var1);

    public final List<TypedValue<String>> getPage(RestConnection connection) {
        List<TypedValue<String>> page;
        Result<InputStream, HttpResponseAttributes> result;
        if (this.stopPaging) {
            return Collections.emptyList();
        }
        HttpRequestBuilder requestBuilder = this.requestFactory.apply(connection);
        this.configureRequest(requestBuilder);
        try {
            result = connection.request(requestBuilder, this.responseTimeout, this.streamingHelper).get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)cause.getMessage()), cause);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MuleRuntimeException((Throwable)e);
        }
        String rawPage = RestConnectUtils.consumeStringAndClose(result.getOutput(), this.encoding);
        if (this.stopPaging) {
            return Collections.emptyList();
        }
        if (RestConnectUtils.isBlank(rawPage)) {
            page = Collections.emptyList();
        } else {
            page = this.extractPayload(rawPage);
            ++this.pageIndex;
        }
        this.onPage(page, rawPage);
        return page;
    }

    public Optional<Integer> getTotalResults(RestConnection connection) {
        return Optional.empty();
    }

    public final void close(RestConnection connection) throws MuleException {
        this.doClose(connection);
    }

    protected void onPage(List<TypedValue<String>> page, String rawPage) {
    }

    protected void stopPaging() {
        this.stopPaging = true;
    }

    protected void doClose(RestConnection connection) throws MuleException {
    }

    protected <T> TypedValue<T> evaluate(String content, String expression, DataType expectedOutputType) {
        return this.expressionLanguage.evaluate(expression, expectedOutputType, this.toBindingContext(content));
    }

    private List<TypedValue<String>> extractPayload(String content) {
        TypedValue payload = this.expressionLanguage.evaluate(this.payloadExpression, this.toBindingContext(content));
        Iterator it = this.expressionLanguage.split("#[payload default []]", this.toBindingContext(payload));
        return this.toList(it);
    }

    private BindingContext toBindingContext(String content) {
        return this.toBindingContext(new TypedValue((Object)content, this.dataType, OptionalLong.of(content.length())));
    }

    private List<TypedValue<String>> toList(Iterator<TypedValue<?>> iterator) {
        LinkedList<TypedValue<String>> list = new LinkedList<TypedValue<String>>();
        while (iterator.hasNext()) {
            String value = RestConnectUtils.consumeStringAndClose(iterator.next().getValue(), this.encoding);
            list.add((TypedValue<String>)new TypedValue((Object)value, this.dataType, OptionalLong.of(value.length())));
        }
        return list;
    }

    private BindingContext toBindingContext(TypedValue<?> content) {
        return BindingContext.builder().addBinding("payload", content).build();
    }
}

