/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.connectors.restconnect.commons.api.operation;

import static java.util.concurrent.TimeUnit.MINUTES;
import static org.mule.runtime.extension.api.annotation.param.display.Placement.ADVANCED_TAB;
import org.mule.runtime.extension.api.annotation.param.ConfigOverride;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

import java.util.concurrent.TimeUnit;

/**
 * A parameter group with the {@code @ConfigOverrides} parameters to be used on all operations
 *
 * @since 1.0
 */
public class ConfigurationOverrides {

  /**
   * The timeout for request to the remote service. This value is qualified by
   * the {@link #responseTimeoutUnit}
   */
  @Parameter
  @ConfigOverride
  @Placement(tab = ADVANCED_TAB)
  @Summary("The timeout for request to the remote service.")
  private Integer responseTimeout;

  /**
   * A time unit which qualifies the {@link #responseTimeout}
   */
  @Parameter
  @ConfigOverride
  @Placement(tab = ADVANCED_TAB)
  @Summary("A time unit which qualifies the Response Timeout}")
  private TimeUnit responseTimeoutUnit = MINUTES;

  public int getResponseTimeoutAsMillis() {
    return Long.valueOf(responseTimeoutUnit.toMillis(responseTimeout)).intValue();
  }

  public Integer getResponseTimeout() {
    return responseTimeout;
  }

  public TimeUnit getResponseTimeoutUnit() {
    return responseTimeoutUnit;
  }
}
