/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectors.restconnect.commons.api.connection;

import java.io.InputStream;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.mule.connectors.restconnect.commons.api.connection.RestConnection;
import org.mule.connectors.restconnect.commons.api.error.RequestException;
import org.mule.connectors.restconnect.commons.api.error.RestConnectError;
import org.mule.connectors.restconnect.commons.api.operation.HttpResponseAttributes;
import org.mule.connectors.restconnect.commons.internal.util.RestConnectUtils;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRestConnection
implements RestConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRestConnection.class);
    private static final String REMOTELY_CLOSED = "Remotely closed";
    private final String baseUri;
    private final String configName;
    private final HttpClient httpClient;
    private final HttpAuthentication authentication;
    private final MultiMap<String, String> defaultQueryParams;
    private final MultiMap<String, String> defaultHeaders;

    public DefaultRestConnection(String baseUri, String configName, HttpClient httpClient, HttpAuthentication authentication, MultiMap<String, String> defaultQueryParams, MultiMap<String, String> defaultHeaders) {
        this.baseUri = baseUri;
        this.configName = configName;
        this.httpClient = httpClient;
        this.authentication = authentication;
        this.defaultQueryParams = this.nullSafe(defaultQueryParams);
        this.defaultHeaders = this.nullSafe(defaultHeaders);
    }

    private void merge(MultiMap<String, String> defaultValues, Predicate<String> appendPredicate, BiConsumer<String, List<String>> appender) {
        defaultValues.keySet().forEach(k -> {
            if (appendPredicate.test((String)k)) {
                appender.accept((String)k, defaultValues.getAll(k));
            }
        });
    }

    @Override
    public CompletableFuture<Result<String, HttpResponseAttributes>> bodylessRequest(HttpRequestBuilder requestBuilder, int responseTimeoutMillis, StreamingHelper streamingHelper) {
        CompletableFuture<Result<String, HttpResponseAttributes>> future = new CompletableFuture<Result<String, HttpResponseAttributes>>();
        this.request(requestBuilder, responseTimeoutMillis, streamingHelper).whenComplete((r, e) -> {
            if (e != null) {
                future.completeExceptionally((Throwable)e);
            } else {
                try {
                    Result.Builder voidResult = Result.builder().output((Object)"").length(0L);
                    r.getAttributes().ifPresent(arg_0 -> ((Result.Builder)voidResult).attributes(arg_0));
                    r.getMediaType().ifPresent(arg_0 -> ((Result.Builder)voidResult).mediaType(arg_0));
                    r.getAttributesMediaType().ifPresent(arg_0 -> ((Result.Builder)voidResult).attributesMediaType(arg_0));
                    future.complete(voidResult.build());
                }
                finally {
                    RestConnectUtils.closeStream(r.getOutput());
                }
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Result<InputStream, HttpResponseAttributes>> request(HttpRequestBuilder requestBuilder, int responseTimeoutMillis, StreamingHelper streamingHelper) {
        CompletableFuture<Result<InputStream, HttpResponseAttributes>> future = new CompletableFuture<Result<InputStream, HttpResponseAttributes>>();
        MultiMap headers = requestBuilder.getHeaders();
        MultiMap queryParams = requestBuilder.getQueryParams();
        this.merge(this.defaultHeaders, k -> !headers.containsKey(k), (arg_0, arg_1) -> ((HttpRequestBuilder)requestBuilder).addHeaders(arg_0, arg_1));
        this.merge(this.defaultQueryParams, k -> !queryParams.containsKey(k), (k, vl) -> vl.forEach(v -> requestBuilder.addQueryParam(k, v)));
        HttpRequest request = this.buildRequest(requestBuilder);
        try {
            this.httpClient.sendAsync(request, HttpRequestOptions.builder().responseTimeout(responseTimeoutMillis).followsRedirect(true).authentication(this.authentication).build()).whenComplete((response, t) -> {
                if (t != null) {
                    this.handleRequestException((Throwable)t, request, future);
                } else {
                    this.handleResponse((HttpResponse)response, future, streamingHelper);
                }
            });
        }
        catch (Throwable t2) {
            this.handleRequestException(t2, request, future);
        }
        return future;
    }

    private void handleResponse(HttpResponse response, CompletableFuture<Result<InputStream, HttpResponseAttributes>> future, StreamingHelper streamingHelper) {
        RestConnectError error = RestConnectError.getErrorByCode(response.getStatusCode()).orElse(null);
        if (error != null) {
            this.handleResponseError(response, future, streamingHelper, error);
        } else {
            future.complete(this.toResult(response, false, streamingHelper));
        }
    }

    protected void handleResponseError(HttpResponse response, CompletableFuture<Result<InputStream, HttpResponseAttributes>> future, StreamingHelper streamingHelper, RestConnectError error) {
        future.completeExceptionally((Throwable)((Object)new RequestException(error, this.toResult(response, true, streamingHelper))));
    }

    private void handleRequestException(Throwable t, HttpRequest request, CompletableFuture<Result<InputStream, HttpResponseAttributes>> future) {
        this.checkIfRemotelyClosed(t, request);
        RestConnectError error = t instanceof TimeoutException ? RestConnectError.TIMEOUT : RestConnectError.CONNECTIVITY;
        future.completeExceptionally((Throwable)new ModuleException(t.getMessage(), (ErrorTypeDefinition)error, t));
    }

    private <T> Result<T, HttpResponseAttributes> toResult(HttpResponse response, boolean isError, StreamingHelper streamingHelper) {
        Result.Builder builder;
        block4: {
            builder = Result.builder();
            HttpEntity entity = response.getEntity();
            Object content = entity.getContent();
            if (isError) {
                content = streamingHelper.resolveCursorProvider(content);
            }
            builder.output(content);
            entity.getBytesLength().ifPresent(arg_0 -> ((Result.Builder)builder).length(arg_0));
            String contentType = (String)response.getHeaders().get((Object)"Content-Type");
            if (contentType != null) {
                try {
                    builder.mediaType(MediaType.parse((String)contentType));
                }
                catch (Exception e) {
                    if (!LOGGER.isDebugEnabled()) break block4;
                    LOGGER.debug(String.format("Response Content-Type '%s' could not be parsed to a valid Media Type. Will ignore", contentType), (Throwable)e);
                }
            }
        }
        builder.attributes((Object)this.toAttributes(response)).attributesMediaType(MediaType.APPLICATION_JAVA);
        return builder.build();
    }

    protected HttpRequest buildRequest(HttpRequestBuilder requestBuilder) {
        return requestBuilder.build();
    }

    protected HttpResponseAttributes toAttributes(HttpResponse response) {
        return new HttpResponseAttributes(response.getStatusCode(), response.getReasonPhrase(), (MultiMap<String, String>)response.getHeaders());
    }

    protected void beforeStop() {
    }

    protected void afterStop() {
    }

    private void checkIfRemotelyClosed(Throwable exception, HttpRequest request) {
        if ("https".equals(request.getUri().getScheme()) && RestConnectUtils.containsIgnoreCase(exception.getMessage(), REMOTELY_CLOSED)) {
            LOGGER.error("Remote host closed connection. Possible SSL/TLS handshake issue. Check protocols, cipher suites and certificate set up. Use -Djavax.net.debug=ssl for further debugging.");
        }
    }

    @Override
    public String getBaseUri() {
        return this.baseUri;
    }

    @Override
    public final void stop() {
        try {
            this.beforeStop();
        }
        catch (Throwable t) {
            LOGGER.warn(String.format("Exception found before stopping config '%s'", this.configName), t);
        }
        try {
            this.httpClient.stop();
        }
        catch (Throwable t) {
            LOGGER.warn(String.format("Exception found while stopping http client for config '%s'", this.configName), t);
        }
        try {
            this.afterStop();
        }
        catch (Throwable t) {
            LOGGER.warn(String.format("Exception found after stopping config '%s'", this.configName), t);
        }
    }

    private MultiMap<String, String> nullSafe(MultiMap<String, String> multiMap) {
        return multiMap != null ? multiMap : new MultiMap();
    }
}

