/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectors.restconnect.commons.api.operation;

import java.io.InputStream;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.mule.connectors.restconnect.commons.api.connection.RestConnection;
import org.mule.connectors.restconnect.commons.api.operation.HttpResponseAttributes;
import org.mule.connectors.restconnect.commons.api.operation.RequestParameters;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRestConnectOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseRestConnectOperation.class);

    protected void doRequest(RestConnection connection, HttpRequestBuilder builder, int responseTimeoutMillis, StreamingHelper streamingHelper, CompletionCallback<InputStream, HttpResponseAttributes> callback) {
        try {
            connection.request(builder, responseTimeoutMillis, streamingHelper).whenComplete((BiConsumer)this.handleResponse(callback));
        }
        catch (Throwable t) {
            callback.error(t);
        }
    }

    protected void doVoidRequest(RestConnection connection, HttpRequestBuilder builder, int responseTimeoutMillis, StreamingHelper streamingHelper, CompletionCallback<String, HttpResponseAttributes> callback) {
        try {
            connection.bodylessRequest(builder, responseTimeoutMillis, streamingHelper).whenComplete((BiConsumer)this.handleResponse(callback));
        }
        catch (Throwable t) {
            callback.error(t);
        }
    }

    protected void setBody(HttpRequestBuilder builder, TypedValue<InputStream> body) {
        if (body != null) {
            this.setContentLengthHeader(body, builder);
            this.setContentType(body, builder);
            if (body.getValue() != null) {
                builder.entity((HttpEntity)new InputStreamHttpEntity((InputStream)body.getValue()));
            }
        }
    }

    private <T> BiConsumer<Result<T, HttpResponseAttributes>, Throwable> handleResponse(CompletionCallback<T, HttpResponseAttributes> callback) {
        return (r, e) -> {
            if (e != null) {
                callback.error(e);
            } else {
                callback.success(r);
            }
        };
    }

    protected HttpRequestBuilder requestBuilder(String baseUri, String path, HttpConstants.Method method, RequestParameters parameters) {
        String uri = this.buildRequestUri(baseUri, path);
        HttpRequestBuilder builder = HttpRequest.builder().method(method).uri(uri);
        builder.headers(parameters.getCustomHeaders());
        builder.queryParams(parameters.getCustomQueryParams());
        return builder;
    }

    private void setContentType(TypedValue<InputStream> body, HttpRequestBuilder builder) {
        MediaType mediaType;
        if (!builder.getHeaderValue("Content-Type").isPresent() && (mediaType = body.getDataType().getMediaType()) != null && !mediaType.getPrimaryType().equals("*")) {
            builder.addHeader("Content-Type", mediaType.toRfcString());
        }
    }

    private void setContentLengthHeader(TypedValue<InputStream> body, HttpRequestBuilder builder) {
        Optional customLength = builder.getHeaderValue("Content-Length");
        boolean isChunked = builder.getHeaderValue("Transfer-Encoding").map("chunked"::equals).orElse(false);
        if (body.getByteLength().isPresent()) {
            boolean addHeader = true;
            String length = String.valueOf(body.getByteLength().getAsLong());
            if (customLength.isPresent()) {
                LOGGER.warn("Invoking URI {} with body of known length {}. However, a {} header with value {} was manually specified. Will proceed with the custom value.", new Object[]{builder.getUri(), length, "Content-Length", customLength.get()});
                addHeader = false;
            }
            if (isChunked) {
                LOGGER.debug("Invoking URI {} with a manually set {}: {} header, even though body is of known length {}. Skipping automatic addition of {} header", new Object[]{builder.getUri(), "Transfer-Encoding", "chunked", length, "Content-Length"});
                addHeader = false;
            }
            if (addHeader) {
                builder.addHeader("Content-Length", length);
            }
        } else if (!isChunked && !customLength.isPresent()) {
            builder.addHeader("Transfer-Encoding", "chunked");
        }
    }

    private String buildRequestUri(String baseUri, String path) {
        boolean pathStartsWithSlash = path.startsWith("/");
        boolean baseEndsInSlash = baseUri.endsWith("/");
        if (pathStartsWithSlash && baseEndsInSlash) {
            path = path.substring(1);
        } else if (!pathStartsWithSlash && !baseEndsInSlash) {
            baseUri = baseUri + '/';
        }
        return baseUri + path;
    }
}

