/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectors.restconnect.commons.internal.util;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Optional;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.json.api.JsonTypeLoader;
import org.mule.metadata.xml.api.SchemaCollector;
import org.mule.metadata.xml.api.XmlTypeLoader;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.functional.Either;
import org.mule.runtime.core.api.util.IOUtils;

public final class RestConnectUtils {
    private RestConnectUtils() {
    }

    public static void closeAndRelease(CursorProvider cursorProvider) {
        cursorProvider.close();
        cursorProvider.releaseResources();
    }

    public static void closeStream(Object stream) {
        if (stream instanceof CursorProvider) {
            RestConnectUtils.closeAndRelease((CursorProvider)stream);
        } else if (stream instanceof InputStream) {
            IOUtils.closeQuietly((Closeable)((InputStream)stream));
        }
    }

    public static String consumeStringAndClose(Object stream, String encoding) {
        Either content;
        if (stream == null) {
            return "";
        }
        if (stream instanceof String) {
            return (String)stream;
        }
        if (stream instanceof CursorStreamProvider) {
            content = Either.left((Object)((CursorStreamProvider)stream));
        } else if (stream instanceof InputStream) {
            content = Either.right((Object)((InputStream)stream));
        } else {
            throw new IllegalArgumentException("Cannot consume stream of unsupported type: " + stream.getClass().getName());
        }
        return (String)content.reduce(provider -> {
            try {
                String string = RestConnectUtils.doConsumeAndClose((InputStream)provider.openCursor(), encoding);
                return string;
            }
            finally {
                RestConnectUtils.closeAndRelease((CursorProvider)provider);
            }
        }, in -> RestConnectUtils.doConsumeAndClose(in, encoding));
    }

    private static String doConsumeAndClose(InputStream stream, String encoding) {
        try {
            String string = IOUtils.toString((InputStream)stream, (String)encoding);
            return string;
        }
        finally {
            IOUtils.closeQuietly((Closeable)stream);
        }
    }

    public static boolean isBlank(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static boolean containsIgnoreCase(String value, String predicate) {
        if (value == null || predicate == null) {
            return false;
        }
        return value.toLowerCase().contains(predicate.toLowerCase());
    }

    public static boolean isNotBlank(String v) {
        return v != null && v.trim().length() > 0;
    }

    public static String readSchema(ClassLoader classLoader, String schemaPath) {
        String schema;
        if (schemaPath.startsWith("/")) {
            schemaPath = schemaPath.substring(1);
        }
        try (InputStream in = classLoader.getResourceAsStream(schemaPath);){
            if (in == null) {
                throw new IllegalArgumentException("Could not find schema at " + schemaPath);
            }
            schema = IOUtils.toString((InputStream)in);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return schema;
    }

    public static MetadataType loadXmlSchema(String schemaPath, String schemaContent, String qName) {
        SchemaCollector schemaCollector = SchemaCollector.getInstance().addSchema(schemaPath, (InputStream)new ByteArrayInputStream(schemaContent.getBytes()));
        Optional metadataType = new XmlTypeLoader(schemaCollector).load(qName);
        if (!metadataType.isPresent()) {
            throw new RuntimeException("Could not load XML Schema " + schemaPath + " QName:" + qName);
        }
        return (MetadataType)metadataType.get();
    }

    public static MetadataType loadJsonSchema(String schemaPath, String schemaContent) {
        Optional metadataType = new JsonTypeLoader(schemaContent).load(null);
        if (!metadataType.isPresent()) {
            throw new RuntimeException("Could not load Json Schema " + schemaPath);
        }
        return (MetadataType)metadataType.get();
    }
}

