/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.connectors.restconnect.commons.api.datasense.resolver;

import static org.mule.connectors.restconnect.commons.internal.util.RestConnectUtils.loadJsonSchema;
import org.mule.metadata.api.model.MetadataType;

/**
 * {@link SchemaInputTypeResolver} implementation for Json schemas
 *
 * @since 1.0
 */
public abstract class JsonInputTypeResolver extends SchemaInputTypeResolver {

  @Override
  protected MetadataType loadSchema(String schema) {
    return loadJsonSchema(getSchemaPath(), schema);
  }
}
