/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.connectors.restconnect.commons.api.datasense.resolver;

import static org.mule.metadata.api.model.MetadataFormat.JAVA;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;

/**
 * Base class for {@link OutputTypeResolver}  which resolves a java string type
 * @since 1.0
 */
public abstract class StringOutputTypeResolver implements OutputTypeResolver<Object> {

  @Override
  public MetadataType getOutputType(MetadataContext metadataContext, Object keyLess) {
    return BaseTypeBuilder.create(JAVA).stringType().build();
  }

}
