/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.connectors.restconnect.commons.internal.multipart;

import org.mule.runtime.api.metadata.TypedValue;

import java.io.InputStream;

/**
 * Generic representation of an Http Part.
 *
 * @since 1.0
 */
public class Part {

  protected final String name;
  protected final TypedValue<InputStream> content;

  public Part(String name, TypedValue<InputStream> content) {
    this.name = name;
    this.content = content;
  }

  public String getName() {
    return name;
  }

  public TypedValue<InputStream> getContent() {
    return content;
  }

  public void accept(PartVisitor visitor) {
    visitor.visit(this);
  }
}
