/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.connectors.restconnect.commons.api.datasense.resolver.input;

import static org.mule.connectors.restconnect.commons.internal.util.RestConnectUtils.loadXmlSchema;

import org.mule.metadata.api.model.MetadataType;

/**
 * {@link SchemaInputTypeResolver} that loads an XML schema
 *
 * @since 1.0
 */
public abstract class XmlInputTypeResolver extends SchemaInputTypeResolver {

  @Override
  protected MetadataType loadSchema(String schema) {
    return loadXmlSchema(getSchemaPath(), schema, getQName());
  }

  /**
   * @return the QName for the loaded XML type
   */
  protected abstract String getQName();
}
