/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.connectors.restconnect.commons.api.datasense.resolver.output;

import static org.mule.connectors.restconnect.commons.internal.util.RestConnectUtils.readSchema;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;

/**
 * Base class for {@link OutputTypeResolver} implementations that dynamically load a schema
 *
 * @since 1.0
 */
public abstract class SchemaOutputTypeResolver implements OutputTypeResolver<Object> {

  /**
   * Absolute path to the schema between the context of the owning connector. This path will be read
   * using the {@link Class#getResourceAsStream(String)} method
   *
   * @return the schema path inside the connector
   */
  protected abstract String getSchemaPath();

  /**
   * Parses the given {@code schema} and transforms it to a {@link MetadataType}
   * @param schema the schema to parse
   * @return a {@link MetadataType}
   */
  protected abstract MetadataType loadSchema(String schema);

  @Override
  public MetadataType getOutputType(MetadataContext metadataContext, Object keyLess) {
    return loadSchema(readSchema(getClass().getClassLoader(), getSchemaPath()));
  }
}
