/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectors.restconnect.commons.api.connection.oauth;

import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import org.mule.connectors.restconnect.commons.api.connection.DefaultRestConnection;
import org.mule.connectors.restconnect.commons.api.error.RestConnectError;
import org.mule.connectors.restconnect.commons.api.operation.HttpResponseAttributes;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.connectivity.oauth.AccessTokenExpiredException;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthState;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

public class OAuthRestConnection
extends DefaultRestConnection {
    private final OAuthState oauthState;
    private final String resourceOwnerId;

    public OAuthRestConnection(String baseUri, String configName, HttpClient httpClient, HttpAuthentication authentication, MultiMap<String, String> defaultQueryParams, MultiMap<String, String> defaultHeaders, OAuthState oauthState, String resourceOwnerId) {
        super(baseUri, configName, httpClient, authentication, defaultQueryParams, defaultHeaders);
        Preconditions.checkArgument((resourceOwnerId != null ? 1 : 0) != 0, (String)"resourceOwnerId cannot be null");
        this.resourceOwnerId = resourceOwnerId;
        Preconditions.checkArgument((oauthState != null ? 1 : 0) != 0, (String)"oauthState cannot be null");
        this.oauthState = oauthState;
    }

    @Override
    protected HttpRequest buildRequest(HttpRequestBuilder requestBuilder) {
        requestBuilder.addHeader("Authorization", "Bearer " + this.oauthState.getAccessToken());
        return super.buildRequest(requestBuilder);
    }

    @Override
    protected void handleResponseError(HttpResponse response, MediaType defaultResponseMediaType, CompletableFuture<Result<InputStream, HttpResponseAttributes>> future, StreamingHelper streamingHelper, RestConnectError error) {
        if (error == RestConnectError.UNAUTHORIZED) {
            future.completeExceptionally((Throwable)new AccessTokenExpiredException(this.resourceOwnerId));
        } else {
            super.handleResponseError(response, defaultResponseMediaType, future, streamingHelper, error);
        }
    }
}

