/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectors.restconnect.commons.api.operation;

import java.io.Closeable;
import java.io.InputStream;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.mule.connectors.restconnect.commons.api.configuration.RestConnectConfiguration;
import org.mule.connectors.restconnect.commons.api.configuration.StreamingType;
import org.mule.connectors.restconnect.commons.api.connection.RestConnection;
import org.mule.connectors.restconnect.commons.api.multipart.MultipartPayloadBuilder;
import org.mule.connectors.restconnect.commons.api.operation.HttpResponseAttributes;
import org.mule.connectors.restconnect.commons.api.operation.RequestParameters;
import org.mule.connectors.restconnect.commons.internal.multipart.DWMultipartPayloadBuilder;
import org.mule.connectors.restconnect.commons.internal.util.CloserCompletionCallbackDecorator;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRestConnectOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseRestConnectOperation.class);
    @Inject
    private ExpressionLanguage expressionLanguage;

    protected void doRequest(RestConnectConfiguration config, RestConnection connection, HttpRequestBuilder builder, int responseTimeoutMillis, StreamingHelper streamingHelper, CompletionCallback<InputStream, HttpResponseAttributes> callback) {
        try {
            connection.request(builder, responseTimeoutMillis, this.resolveDefaultResponseMediaType(config), streamingHelper).whenComplete((BiConsumer)this.handleResponse(callback));
        }
        catch (Throwable t) {
            callback.error(t);
        }
    }

    protected MediaType resolveDefaultResponseMediaType(RestConnectConfiguration config) {
        MediaType mediaType = this.getDefaultResponseMediaType();
        if (!mediaType.getCharset().isPresent()) {
            mediaType = mediaType.withCharset(config.getCharset());
        }
        return mediaType;
    }

    protected void doVoidRequest(RestConnection connection, HttpRequestBuilder builder, int responseTimeoutMillis, StreamingHelper streamingHelper, CompletionCallback<String, HttpResponseAttributes> callback) {
        try {
            connection.bodylessRequest(builder, responseTimeoutMillis, MediaType.ANY, streamingHelper).whenComplete((BiConsumer)this.handleResponse(callback));
        }
        catch (Throwable t) {
            callback.error(t);
        }
    }

    protected void setBody(HttpRequestBuilder builder, TypedValue<InputStream> body, StreamingType streamingType) {
        if (body != null) {
            byte[] bytes = null;
            if (streamingType.equals((Object)StreamingType.ALWAYS)) {
                builder.removeHeader("Content-Length");
                builder.removeHeader("Transfer-Encoding");
                builder.addHeader("Transfer-Encoding", "chunked");
            } else if (streamingType.equals((Object)StreamingType.NEVER)) {
                bytes = this.setNeverStreamingContentLength(body, builder);
            } else {
                this.setAutoContentLengthHeader(body, builder);
            }
            this.setContentType(body, builder);
            if (body.getValue() != null) {
                if (bytes != null) {
                    builder.entity((HttpEntity)new ByteArrayHttpEntity(bytes));
                } else {
                    builder.entity((HttpEntity)new InputStreamHttpEntity((InputStream)body.getValue()));
                }
            }
        }
    }

    private <T> BiConsumer<Result<T, HttpResponseAttributes>, Throwable> handleResponse(CompletionCallback<T, HttpResponseAttributes> callback) {
        return (r, e) -> {
            if (e != null) {
                callback.error(e);
            } else {
                callback.success(r);
            }
        };
    }

    protected <T, A> void withMultipart(Consumer<MultipartPayloadBuilder> builderConfigurer, CompletionCallback<T, A> callback, BiConsumer<TypedValue<InputStream>, CompletionCallback<T, A>> consumer) {
        DWMultipartPayloadBuilder builder = new DWMultipartPayloadBuilder(this.expressionLanguage);
        builderConfigurer.accept(builder);
        TypedValue<InputStream> multipart = builder.build();
        try {
            consumer.accept(multipart, new CloserCompletionCallbackDecorator<T, A>(callback, (Closeable)multipart.getValue()));
        }
        catch (Exception e) {
            IOUtils.closeQuietly((Closeable)((Closeable)multipart.getValue()));
            callback.error((Throwable)e);
        }
    }

    protected HttpRequestBuilder requestBuilder(String baseUri, String path, HttpConstants.Method method, RequestParameters parameters) {
        String uri = this.buildRequestUri(baseUri, path);
        HttpRequestBuilder builder = HttpRequest.builder().method(method).uri(uri);
        builder.headers(parameters.getCustomHeaders());
        builder.queryParams(parameters.getCustomQueryParams());
        return builder;
    }

    protected MediaType getDefaultResponseMediaType() {
        return MediaType.APPLICATION_JSON;
    }

    private void setContentType(TypedValue<InputStream> body, HttpRequestBuilder builder) {
        MediaType mediaType;
        if (!builder.getHeaderValue("Content-Type").isPresent() && (mediaType = body.getDataType().getMediaType()) != null && !mediaType.getPrimaryType().equals("*")) {
            builder.addHeader("Content-Type", mediaType.toRfcString());
        }
    }

    private byte[] setNeverStreamingContentLength(TypedValue<InputStream> body, HttpRequestBuilder builder) {
        Optional customLength = builder.getHeaderValue("Content-Length");
        byte[] bytes = null;
        if (!customLength.isPresent()) {
            if (body.getByteLength().isPresent()) {
                builder.addHeader("Content-Length", String.valueOf(body.getByteLength().getAsLong()));
            } else if (body.getValue() != null) {
                bytes = IOUtils.toByteArray((InputStream)((InputStream)body.getValue()));
                builder.addHeader("Content-Length", String.valueOf(bytes.length));
            }
        }
        builder.removeHeader("Transfer-Encoding");
        return bytes;
    }

    private void setAutoContentLengthHeader(TypedValue<InputStream> body, HttpRequestBuilder builder) {
        Optional customLength = builder.getHeaderValue("Content-Length");
        boolean isChunked = builder.getHeaderValue("Transfer-Encoding").map("chunked"::equals).orElse(false);
        if (body.getByteLength().isPresent()) {
            boolean addHeader = true;
            String length = String.valueOf(body.getByteLength().getAsLong());
            if (customLength.isPresent()) {
                LOGGER.warn("Invoking URI {} with body of known length {}. However, a {} header with value {} was manually specified. Will proceed with the custom value.", new Object[]{builder.getUri(), length, "Content-Length", customLength.get()});
                addHeader = false;
            }
            if (isChunked) {
                LOGGER.debug("Invoking URI {} with a manually set {}: {} header, even though body is of known length {}. Skipping automatic addition of {} header", new Object[]{builder.getUri(), "Transfer-Encoding", "chunked", length, "Content-Length"});
                addHeader = false;
            }
            if (addHeader) {
                builder.addHeader("Content-Length", length);
            }
        } else if (!isChunked && !customLength.isPresent()) {
            builder.addHeader("Transfer-Encoding", "chunked");
        }
    }

    private String buildRequestUri(String baseUri, String path) {
        boolean pathStartsWithSlash = path.startsWith("/");
        boolean baseEndsInSlash = baseUri.endsWith("/");
        if (pathStartsWithSlash && baseEndsInSlash) {
            path = path.substring(1);
        } else if (!pathStartsWithSlash && !baseEndsInSlash) {
            baseUri = baseUri + '/';
        }
        return baseUri + path;
    }
}

