/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.connectors.restconnect.commons.api.operation.queryparam;

import static java.lang.String.join;
import org.mule.runtime.api.util.MultiMap;

/***
 * A {@link QueryParamFormatter} that formats the query parameters multimap so arrays are split with commas
 * i.e queryParam1=value1,value2&queryParam2=value3
 *
 * @since 1.0
 */
public class CommaQueryParamFormatter implements QueryParamFormatter {

  @Override
  public MultiMap<String, String> format(MultiMap<String, String> queryParams) {
    MultiMap<String, String> formatted = new MultiMap<>();

    for (String queryParam : queryParams.keySet()) {
      if (!formatted.containsKey(queryParam)) {
        formatted.put(queryParam, join(",", queryParams.getAll(queryParam)));
      }
    }

    return formatted;
  }
}
