/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.connectors.restconnect.commons.internal.datasense.loader;

import org.everit.json.schema.Schema;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.json.api.handler.ArrayHandler;
import org.mule.metadata.json.api.handler.BooleanHandler;
import org.mule.metadata.json.api.handler.CombinedHandler;
import org.mule.metadata.json.api.handler.EmptyHandler;
import org.mule.metadata.json.api.handler.EnumHandler;
import org.mule.metadata.json.api.handler.HandlerManager;
import org.mule.metadata.json.api.handler.NullHandler;
import org.mule.metadata.json.api.handler.NumberHandler;
import org.mule.metadata.json.api.handler.ObjectHandler;
import org.mule.metadata.json.api.handler.ParsingContext;
import org.mule.metadata.json.api.handler.ReferenceHandler;
import org.mule.metadata.json.api.handler.SchemaHandler;
import org.mule.metadata.json.api.handler.StringHandler;

import java.util.Arrays;
import java.util.List;

/***
 * A custom implementation of HandlerManager that allows setting a custom MetadataFormat to the type being loaded.
 *
 * This class is needed for Rest Connect Commons to be backwards compatible with Mule 4.2.1
 *
 * @since 1.0
 */
public class CustomMetadataFormatHandlerManager extends HandlerManager {

  private MetadataFormat metadataFormat;

  public CustomMetadataFormatHandlerManager(MetadataFormat metadataFormat) {
    this.metadataFormat = metadataFormat;
  }

  private List<? extends SchemaHandler> handlers =
      Arrays.asList(new ArrayHandler(), new BooleanHandler(), new CombinedHandler(), new EmptyHandler(),
                    new EnumHandler(),
                    new NullHandler(), new NumberHandler(), new ObjectHandler(), new ReferenceHandler(),
                    new StringHandler());

  @Override
  public TypeBuilder<?> handle(Schema schema, ParsingContext parsingContext) {
    if (parsingContext.isAlreadyBuild(schema)) {
      return parsingContext.getBuilder(schema).orElse(null);
    } else {
      for (SchemaHandler handler : handlers) {
        if (handler.handles(schema)) {
          return handler.handle(schema, BaseTypeBuilder.create(metadataFormat), this, parsingContext);
        }
      }
      // If no type was detected we just generate any
      return BaseTypeBuilder.create(metadataFormat).anyType();
    }
  }
}
