/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.connectors.restconnect.commons.internal.multipart;

import org.mule.runtime.api.metadata.TypedValue;

import java.io.InputStream;

/**
 * A {@link Part} that carries a file attachment
 *
 * @since 1.0
 */
public class FilePart extends Part {

  private final String filename;

  public FilePart(String name, String filename, TypedValue<InputStream> content) {
    super(name, content);
    this.filename = filename;
  }

  public String getFilename() {
    return filename;
  }

  @Override
  public void accept(PartVisitor visitor) {
    visitor.visit(this);
  }
}
