/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectors.restconnect.commons.internal.datasense.loader;

import java.util.Optional;
import org.everit.json.schema.Schema;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.mule.connectors.restconnect.commons.internal.datasense.loader.CustomMetadataFormatHandlerManager;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.json.api.handler.ParsingContext;
import org.mule.metadata.json.api.utils.SchemaHelper;

public class CustomJsonSchemaTypeLoader
implements TypeLoader {
    private JsonSchemaStringLoader jsonSchemaLoader;
    private MetadataFormat metadataType;

    public CustomJsonSchemaTypeLoader(String schemaData, MetadataFormat metadataType) {
        this.metadataType = metadataType;
        this.jsonSchemaLoader = new JsonSchemaStringLoader(schemaData);
    }

    public Optional<MetadataType> load(String identifier) {
        Schema jsonSchema = this.jsonSchemaLoader.loadSchema();
        TypeBuilder<?> typeBuilder = new CustomMetadataFormatHandlerManager(this.metadataType).handle(jsonSchema, new ParsingContext());
        MetadataTypeUtils.addTypeAlias(typeBuilder, null);
        return Optional.of(typeBuilder.build());
    }

    private static class JsonSchemaStringLoader {
        private String schemaData;

        public JsonSchemaStringLoader(String schemaData) {
            this.schemaData = schemaData;
        }

        public Schema loadSchema() {
            JSONObject rawSchema = new JSONObject(new JSONTokener(this.schemaData));
            return SchemaHelper.generateSchema((JSONObject)rawSchema, null);
        }
    }
}

