/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectors.restconnect.commons.internal.util;

import java.io.Closeable;
import java.io.InputStream;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.functional.Either;
import org.mule.runtime.core.api.util.IOUtils;

public final class RestConnectUtils {
    private RestConnectUtils() {
    }

    public static void closeAndRelease(CursorProvider cursorProvider) {
        cursorProvider.close();
        cursorProvider.releaseResources();
    }

    public static void closeStream(Object stream) {
        if (stream instanceof CursorProvider) {
            RestConnectUtils.closeAndRelease((CursorProvider)stream);
        } else if (stream instanceof InputStream) {
            IOUtils.closeQuietly((Closeable)((InputStream)stream));
        }
    }

    public static String consumeStringAndClose(Object stream, String encoding) {
        Either content;
        if (stream == null) {
            return "";
        }
        if (stream instanceof String) {
            return (String)stream;
        }
        if (stream instanceof CursorStreamProvider) {
            content = Either.left((Object)((CursorStreamProvider)stream));
        } else if (stream instanceof InputStream) {
            content = Either.right((Object)((InputStream)stream));
        } else {
            throw new IllegalArgumentException("Cannot consume stream of unsupported type: " + stream.getClass().getName());
        }
        return (String)content.reduce(provider -> {
            try {
                String string = RestConnectUtils.doConsumeAndClose((InputStream)provider.openCursor(), encoding);
                return string;
            }
            finally {
                RestConnectUtils.closeAndRelease((CursorProvider)provider);
            }
        }, in -> RestConnectUtils.doConsumeAndClose(in, encoding));
    }

    private static String doConsumeAndClose(InputStream stream, String encoding) {
        try {
            String string = IOUtils.toString((InputStream)stream, (String)encoding);
            return string;
        }
        finally {
            IOUtils.closeQuietly((Closeable)stream);
        }
    }

    public static boolean isBlank(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static boolean containsIgnoreCase(String value, String predicate) {
        if (value == null || predicate == null) {
            return false;
        }
        return value.toLowerCase().contains(predicate.toLowerCase());
    }

    public static boolean isNotBlank(String v) {
        return v != null && v.trim().length() > 0;
    }
}

