/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.connectors.restconnect.commons.api.connection.oauth;

import org.mule.connectors.restconnect.commons.api.connection.BaseConnectionProvider;
import org.mule.connectors.restconnect.commons.api.connection.RestConnection;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeState;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;

/**
 * Base class for Connection Providers that authenticate using OAuth with the Authorization Code Grant Type
 *
 * @since 1.0
 */
public abstract class BaseAuthorizationCodeConnectionProvider extends BaseConnectionProvider {

  private AuthorizationCodeState oauthState;


  @Override
  protected RestConnection createConnection(HttpClient httpClient,
                                            HttpAuthentication authentication,
                                            MultiMap<String, String> defaultQueryParams,
                                            MultiMap<String, String> defaultHeaders) {
    return new OAuthRestConnection(getBaseUri(),
                                   getConfigName(),
                                   httpClient,
                                   authentication,
                                   defaultQueryParams,
                                   defaultHeaders,
                                   getOAuthState(),
                                   getOAuthState().getResourceOwnerId());
  }

  protected AuthorizationCodeState getOAuthState() {
    return oauthState;
  }
}
