/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.connectors.restconnect.commons.api.datasense.resolver.input;

import static org.mule.metadata.api.model.MetadataFormat.JAVA;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataType;

/**
 * Base class for a {@link PrimitiveInputMetadataResolver} which resolves a java date type.
 * This is only meant to be used in generic connectors generated using Rest Connect.
 * For hand-made custom connectors a Java Type can be used instead.
 *
 * @since 1.0
 */
public abstract class DateOnlyInputMetadataResolver extends PrimitiveInputMetadataResolver {

  @Override
  public MetadataType getStaticMetadata() {
    return BaseTypeBuilder.create(JAVA).dateType().build();
  }
}
