/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.connectors.restconnect.commons.api.datasense.resolver.input;

import static org.mule.connectors.restconnect.commons.internal.util.RestConnectUtils.loadJsonSchema;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;

/**
 * {@link SchemaInputMetadataResolver} implementation for Json schemas.
 * This class allows defining a custom metadata format for the schema being loaded by overriding the getMetadataFormat() format.
 *
 * @since 1.0
 */
public abstract class FromJsonInputMetadataResolver extends SchemaInputMetadataResolver {

  protected abstract MetadataFormat getFormat();

  @Override
  protected MetadataType loadSchema(String schema) {
    return loadJsonSchema(getSchemaPath(), schema, getFormat());
  }
}
