/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.connectors.restconnect.commons.api.multipart;

import org.mule.runtime.api.metadata.TypedValue;

import java.io.InputStream;

/**
 * Allows to declare and build the body of a multipart request
 *
 * @since 1.0
 */
public interface MultipartPayloadBuilder {

  /**
   * Adds a simple type
   *
   * @param partName the part name
   * @param content  the part content
   * @return {@code this} builder
   */
  MultipartPayloadBuilder addPart(String partName, TypedValue<InputStream> content);

  /**
   * Adds a part which carries an attachment file
   *
   * @param partName the part name
   * @param filename the file's name
   * @param content  the file's content
   * @return {@code this} builder
   */
  MultipartPayloadBuilder addFilePart(String partName, String filename, TypedValue<InputStream> content);

  /**
   * Allows to specify the boundary that will separate the parts
   *
   * @param boundary the boundary
   * @return {@code this} builder
   */
  MultipartPayloadBuilder setBoundary(String boundary);

  /**
   * Returns the built body as an {@link InputStream}
   *
   * @return the built body
   */
  TypedValue<InputStream> build();

}
