/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.connectors.restconnect.commons.api.operation.queryparam;

import org.mule.runtime.api.util.MultiMap;

/***
 * Formats the query params of a request so they are sent using the desired format.
 *
 * @since 1.0
 */
public interface QueryParamFormatter {

  /***
   * Formats the query params of a request so they are sent using the desired format.
   * For the input multimap every key/value query parameter will have an entry in the multimap.
   * Each value of the @return multimap will be sent as a key/value in the http request.
   *
   * @param queryParams   A {@link MultiMap} of query parameters that must be sent in a http request
   * @return              A multimap where the query parameters are formatted.
   */
  MultiMap<String, String> format(MultiMap<String, String> queryParams);
}
