/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.connectors.restconnect.commons.internal.util;

import static org.mule.runtime.core.api.util.IOUtils.closeQuietly;

import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;

import java.io.Closeable;

/**
 * A {@link CompletionCallbackDecorator} which makes sure that a given {@link #closeable} is always closed
 * upon completion
 *
 * @param <T> the generic payload type
 * @param <A> the generic attributes type
 * @since 1.0
 */
public class CloserCompletionCallbackDecorator<T, A> extends CompletionCallbackDecorator<T, A> {

  private final Closeable closeable;

  public CloserCompletionCallbackDecorator(CompletionCallback<T, A> delegate,
                                           Closeable closeable) {
    super(delegate);
    this.closeable = closeable;
  }

  @Override
  public void success(Result<T, A> result) {
    try {
      super.success(result);
    } finally {
      closeQuietly(closeable);
    }
  }

  @Override
  public void error(Throwable throwable) {
    try {
      super.error(throwable);
    } finally {
      closeQuietly(closeable);
    }
  }
}
