/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.runtime;

import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.collection.IsMapContaining;
import org.junit.Assert;
import org.junit.Test;
import org.mule.soap.AbstractSoapServiceTestCase;
import org.mule.soap.SoapTestUtils;
import org.mule.soap.api.message.SoapRequest;
import org.mule.soap.api.message.SoapResponse;
import org.mule.soap.api.transport.TransportDispatcher;
import org.mule.soap.api.transport.TransportRequest;
import org.mule.soap.api.transport.TransportResponse;
import org.mule.soap.internal.client.TestSoapClient;
import org.mule.soap.internal.message.DefaultSoapRequest;

public class CustomDispatcherTestCase
extends AbstractSoapServiceTestCase {
    private static final String RESPONSE = "<text>RESPONSE</text>";

    @Test
    public void customDispatcher() throws Exception {
        SoapResponse response = this.getTestClient().consume(SoapRequest.empty((String)"noParams"), new TestDispatcher());
        SoapTestUtils.assertSimilarXml(RESPONSE, response.getContent());
    }

    @Test
    public void transportHeaders() {
        DefaultSoapRequest request = SoapRequest.builder().operation("noParams").transportHeaders((Map)ImmutableMap.builder().put((Object)"H1", (Object)"H1Value").put((Object)"H2", (Object)"H2Value").build()).build();
        SoapResponse response = this.getTestClient().consume((SoapRequest)request, new TestDispatcher());
        Map transportHeaders = response.getTransportHeaders();
        Assert.assertThat(transportHeaders.entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)4));
        Assert.assertThat((Object)transportHeaders, (Matcher)IsMapContaining.hasEntry((Object)"H1", (Object)"H1Value"));
        Assert.assertThat((Object)transportHeaders, (Matcher)IsMapContaining.hasEntry((Object)"H2", (Object)"H2Value"));
    }

    private TestSoapClient getTestClient() {
        return new TestSoapClient(TestSoapClient.getDefaultConfiguration(this.server.getDefaultAddress()).withVersion(this.soapVersion).build());
    }

    public class TestDispatcher
    implements TransportDispatcher {
        public TransportResponse dispatch(TransportRequest dispatchingRequest) {
            String envelope = "<s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\"><s:Body><text>RESPONSE</text></s:Body></s:Envelope>";
            return new TransportResponse((InputStream)new ByteArrayInputStream(envelope.getBytes()), dispatchingRequest.getHeaders());
        }
    }
}

