/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.runtime;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mule.soap.AbstractSoapServiceTestCase;
import org.mule.soap.SoapTestUtils;
import org.mule.soap.api.client.SoapClient;
import org.mule.soap.api.message.SoapRequest;
import org.mule.soap.api.message.SoapResponse;
import org.mule.soap.internal.client.TestSoapClient;
import org.mule.soap.internal.message.DefaultSoapRequest;

public class OperationExecutionTestCase
extends AbstractSoapServiceTestCase {
    @Test
    public void simpleOperation() throws Exception {
        this.testSimpleOperation(this.client);
    }

    @Test
    public void echoWithLocalWsdl() throws Exception {
        URL wsdl = Thread.currentThread().getContextClassLoader().getResource("wsdl/simple-service.wsdl");
        TestSoapClient localWsdlClient = new TestSoapClient(TestSoapClient.getDefaultConfiguration(this.server.getDefaultAddress()).withWsdlLocation(wsdl.getPath()).withVersion(this.soapVersion).build());
        this.testSimpleOperation(localWsdlClient);
    }

    @Test
    public void simpleOperationWithHeaders() throws Exception {
        ImmutableMap headers = ImmutableMap.builder().put((Object)"headerIn", (Object)this.testValues.getHeaderIn()).put((Object)"headerInOut", (Object)this.testValues.getHeaderInOutRequest()).build();
        DefaultSoapRequest req = SoapRequest.builder().content(this.testValues.getEchoWithHeadersRequest()).operation("echoWithHeaders").soapHeaders((Map)headers).contentType("application/xml").build();
        SoapResponse response = this.client.consume((SoapRequest)req, null);
        SoapTestUtils.assertSimilarXml((String)response.getSoapHeaders().get("headerOut"), this.testValues.getHeaderOut());
        SoapTestUtils.assertSimilarXml((String)response.getSoapHeaders().get("headerInOut"), this.testValues.getHeaderInOutResponse());
        SoapTestUtils.assertSimilarXml(this.testValues.getEchoWithHeadersResponse(), response.getContent());
    }

    @Test
    public void complexTypeOperation() throws Exception {
        DefaultSoapRequest req = SoapRequest.builder().content(this.testValues.getEchoAccountRequest()).operation("echoAccount").build();
        SoapResponse response = this.client.consume((SoapRequest)req, null);
        MatcherAssert.assertThat((Object)response.getSoapHeaders().isEmpty(), (Matcher)Is.is((Object)true));
        SoapTestUtils.assertSimilarXml(this.testValues.getEchoAccountResponse(), response.getContent());
    }

    @Test
    public void noParamsOperation() throws Exception {
        DefaultSoapRequest req = SoapRequest.builder().content(this.testValues.getNoParamsRequest()).operation("noParams").build();
        this.testNoParams((SoapRequest)req);
    }

    @Test
    public void large() throws Exception {
        DefaultSoapRequest req = SoapRequest.builder().operation("large").build();
        InputStream response = this.client.consume((SoapRequest)req, null).getContent();
        String largeContent = IOUtils.toString((InputStream)Thread.currentThread().getContextClassLoader().getResource("large.json").openStream());
        SoapTestUtils.assertSimilarXml(this.testValues.buildXml("largeResponse", "<largeResponse>" + largeContent + "</largeResponse>"), response);
    }

    @Test
    public void noParamsOperationWithoutXmlPayload() throws Exception {
        this.testNoParams(SoapRequest.empty((String)"noParams"));
    }

    @Test
    public void transportHeaders() {
        DefaultSoapRequest request = SoapRequest.builder().content(this.testValues.getEchoResquest()).operation("echo").build();
        SoapResponse response = this.client.consume((SoapRequest)request, null);
        Map transportHeaders = response.getTransportHeaders();
        MatcherAssert.assertThat(transportHeaders.entrySet(), (Matcher)Matchers.hasSize((int)4));
    }

    @Test
    public void oneWayOperation() throws IOException {
        DefaultSoapRequest req = SoapRequest.builder().operation("oneWay").content(this.testValues.getOneWayRequest()).build();
        SoapResponse response = this.client.consume((SoapRequest)req, null);
        MatcherAssert.assertThat((Object)IOUtils.toString((InputStream)response.getContent()), (Matcher)Is.is((Object)""));
        MatcherAssert.assertThat((Object)response.getContentType(), (Matcher)Is.is((Object)"*/*"));
    }

    private void testSimpleOperation(SoapClient client) throws Exception {
        DefaultSoapRequest request = SoapRequest.builder().content(this.testValues.getEchoResquest()).operation("echo").build();
        SoapResponse response = client.consume((SoapRequest)request, null);
        MatcherAssert.assertThat((Object)response.getSoapHeaders().isEmpty(), (Matcher)Is.is((Object)true));
        SoapTestUtils.assertSimilarXml(this.testValues.getEchoResponse(), response.getContent());
    }

    private void testNoParams(SoapRequest request) throws Exception {
        SoapResponse response = this.client.consume(request, null);
        MatcherAssert.assertThat((Object)response.getSoapHeaders().isEmpty(), (Matcher)Is.is((Object)true));
        SoapTestUtils.assertSimilarXml(this.testValues.getNoParamsResponse(), response.getContent());
    }
}

