/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.api.security;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.mule.soap.api.security.SecurityStrategy;
import org.mule.soap.api.security.stores.WssKeyStoreConfiguration;
import org.mule.soap.internal.security.callback.WSPasswordCallbackHandler;

public class WssSignSecurityStrategy
implements SecurityStrategy {
    private static final String WS_SIGN_PROPERTIES_KEY = "signProperties";
    private final WssKeyStoreConfiguration keyStoreConfiguration;

    public WssSignSecurityStrategy(WssKeyStoreConfiguration keyStoreConfiguration) {
        this.keyStoreConfiguration = keyStoreConfiguration;
    }

    @Override
    public SecurityStrategy.SecurityStrategyType securityType() {
        return SecurityStrategy.SecurityStrategyType.OUTGOING;
    }

    @Override
    public Optional<WSPasswordCallbackHandler> buildPasswordCallbackHandler() {
        return Optional.of(new WSPasswordCallbackHandler(3, cb -> cb.setPassword(this.keyStoreConfiguration.getPassword())));
    }

    @Override
    public String securityAction() {
        return "Signature";
    }

    @Override
    public Map<String, Object> buildSecurityProperties() {
        return ImmutableMap.builder().put((Object)"signaturePropRefId", (Object)WS_SIGN_PROPERTIES_KEY).put((Object)WS_SIGN_PROPERTIES_KEY, (Object)this.keyStoreConfiguration.getConfigurationProperties()).put((Object)"signatureUser", (Object)this.keyStoreConfiguration.getAlias()).build();
    }
}

