/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.api.security;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.mule.soap.api.security.SecurityStrategy;
import org.mule.soap.internal.security.callback.WSPasswordCallbackHandler;

public class WssTimestampSecurityStrategy
implements SecurityStrategy {
    private long timeToLiveInSeconds;
    private boolean checkResponseTimestamp;

    public WssTimestampSecurityStrategy(long timeToLeaveInSeconds, boolean checkResponseTimestamp) {
        this.timeToLiveInSeconds = timeToLeaveInSeconds;
        this.checkResponseTimestamp = checkResponseTimestamp;
    }

    public WssTimestampSecurityStrategy(long timeToLeaveInSeconds) {
        this(timeToLeaveInSeconds, false);
    }

    @Override
    public SecurityStrategy.SecurityStrategyType securityType() {
        return this.checkResponseTimestamp ? SecurityStrategy.SecurityStrategyType.ALWAYS : SecurityStrategy.SecurityStrategyType.OUTGOING;
    }

    @Override
    public Optional<WSPasswordCallbackHandler> buildPasswordCallbackHandler() {
        return Optional.empty();
    }

    @Override
    public String securityAction() {
        return "Timestamp";
    }

    @Override
    public Map<String, Object> buildSecurityProperties() {
        return ImmutableMap.builder().put((Object)"timeToLive", (Object)String.valueOf(this.timeToLiveInSeconds)).build();
    }
}

