/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.internal.generator;

import javax.xml.namespace.QName;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.soap.api.client.BadRequestException;
import org.mule.wsdl.parser.model.PortModel;
import org.mule.wsdl.parser.model.operation.OperationModel;

final class EmptyRequestGenerator {
    private static final String NO_PARAMS_SOAP_BODY_CALL_MASK = "<ns:%s xmlns:ns=\"%s\"/>";
    private PortModel portModel;

    public EmptyRequestGenerator(PortModel portModel) {
        this.portModel = portModel;
    }

    String generateRequest(String operationName) {
        OperationModel operation = this.portModel.getOperation(operationName);
        MetadataType body = operation.getInputType().getBody();
        if (this.isOperationWithRequiredParameters(body)) {
            throw new BadRequestException(String.format("Cannot build default body request for operation [%s], it requires input parameters", operationName));
        }
        QName typeQname = QName.valueOf(operation.getInputType().getBody().getAnnotation(TypeIdAnnotation.class).map(TypeIdAnnotation::getValue).orElseThrow(() -> new BadRequestException("Cannot create empty request for operation [" + operationName + "]")));
        return String.format(NO_PARAMS_SOAP_BODY_CALL_MASK, typeQname.getLocalPart(), typeQname.getNamespaceURI());
    }

    private boolean isOperationWithRequiredParameters(MetadataType wrapperBodyType) {
        if (wrapperBodyType instanceof ObjectType) {
            MetadataType bodyType = ((ObjectFieldType)((ObjectType)wrapperBodyType).getFields().iterator().next()).getValue();
            return bodyType instanceof ObjectType && !((ObjectType)bodyType).getFields().isEmpty();
        }
        return false;
    }
}

