/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.internal.interceptor;

import java.io.InputStream;
import java.util.Collections;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.StaxInEndingInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.transport.MessageObserver;
import org.mule.soap.api.transport.TransportDispatcher;
import org.mule.soap.api.transport.TransportResponse;
import org.mule.soap.internal.interceptor.TransportRequestFactory;
import org.mule.wsdl.parser.model.operation.OperationType;

public class MessageDispatcherInterceptor
extends AbstractPhaseInterceptor<Message> {
    private final MessageObserver messageObserver;

    public MessageDispatcherInterceptor(MessageObserver messageObserver) {
        super("send-ending");
        this.messageObserver = messageObserver;
    }

    public void handleMessage(Message message) throws Fault {
        Exchange exchange = message.getExchange();
        Object encoding = exchange.get((Object)Message.ENCODING);
        message.put((Object)Message.ENCODING, encoding);
        message.getInterceptorChain().doIntercept(message);
        message.setAttachments(Collections.emptyList());
        TransportDispatcher dispatcher = (TransportDispatcher)exchange.get((Object)"mule.soap.dispatcher");
        TransportResponse response = dispatcher.dispatch(TransportRequestFactory.createDispatchingRequest(message));
        exchange.put((Object)StaxInEndingInterceptor.STAX_IN_NOCLOSE, (Object)Boolean.TRUE);
        if (OperationType.ONE_WAY.equals(exchange.get((Object)"mule.soap.operation.type"))) {
            exchange.put((Object)"exchange.finished", (Object)true);
        } else {
            this.handleRequestResponse(exchange, encoding, response);
        }
    }

    private void handleRequestResponse(Exchange exchange, Object encoding, TransportResponse response) {
        MessageImpl inMessage = new MessageImpl();
        inMessage.put((Object)Message.ENCODING, encoding);
        inMessage.put((Object)"Content-Type", (Object)response.getContentType());
        inMessage.setContent(InputStream.class, (Object)response.getContent());
        exchange.put((Object)"mule.soap.transport.headers", (Object)response.getHeaders());
        inMessage.setExchange(exchange);
        this.messageObserver.onMessage((Message)inMessage);
    }
}

