/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap;

public class SoapTestXmlValues {
    public static final String ECHO = "echo";
    public static final String ECHO_HEADERS = "echoWithHeaders";
    public static final String ECHO_ACCOUNT = "echoAccount";
    public static final String NO_PARAMS = "noParams";
    public static final String NO_PARAMS_HEADERS = "noParamsWithHeader";
    public static final String FAIL = "fail";
    public static final String UPLOAD_ATTACHMENT = "uploadAttachment";
    public static final String DOWNLOAD_ATTACHMENT = "downloadAttachment";
    public static final String LARGE = "large";
    public static final String ONE_WAY = "oneWay";
    public static final String HEADER_IN = "headerIn";
    public static final String HEADER_INOUT = "headerInOut";
    public static final String HEADER_OUT = "headerOut";
    private final String ns;

    public SoapTestXmlValues(String ns) {
        this.ns = ns;
    }

    public String getEchoResquest() {
        return this.buildXml(ECHO, "<text>test</text>");
    }

    public String getEchoResponse() {
        return this.buildResponseXml(ECHO, "<text>test response</text>");
    }

    public String getEchoAccountRequest() {
        return this.buildXml(ECHO_ACCOUNT, "<account>\n  <id>12</id>\n  <items>chocolate</items>\n  <items>banana</items>\n  <items>dulce de leche</items>\n  <startingDate>2016-09-23T00:00:00-03:00</startingDate>\n</account>\n<name>Juan</name>");
    }

    public String getEchoAccountResponse() {
        return this.buildResponseXml(ECHO_ACCOUNT, "<account>\n  <clientName>Juan</clientName>\n  <id>12</id>\n  <items>chocolate</items>\n  <items>banana</items>\n  <items>dulce de leche</items>\n  <startingDate>2016-09-23T00:00:00-03:00</startingDate>\n</account>");
    }

    public String getEchoWithHeadersRequest() {
        return this.buildXml(ECHO_HEADERS, "<text>test</text>");
    }

    public String getOneWayRequest() {
        return this.buildXml(ONE_WAY, "<text>text</text>");
    }

    public String getEchoWithHeadersResponse() {
        return this.buildResponseXml(ECHO_HEADERS, "<text>test response</text>");
    }

    public String getFailRequest() {
        return this.buildXml(FAIL, "<text>Fail Message</text>");
    }

    public String getNoParamsRequest() {
        return this.buildXml(NO_PARAMS, "");
    }

    public String getNoParamsResponse() {
        return this.buildResponseXml(NO_PARAMS, "<text>response</text>");
    }

    public String getNoParamsWithHeadersRequest() {
        return this.buildXml(NO_PARAMS_HEADERS, "");
    }

    public String getNoParamsWithHeadersResponse() {
        return this.buildResponseXml(NO_PARAMS_HEADERS, "<text>Header In Value</text>");
    }

    public String getDownloadAttachmentRequest() {
        return this.buildXml(DOWNLOAD_ATTACHMENT, "<fileName>attachment.txt</fileName>");
    }

    public String getDownloadAttachmentResponse() {
        return this.buildResponseXml(DOWNLOAD_ATTACHMENT, "");
    }

    public String getUploadAttachmentRequest() {
        return this.buildXml(UPLOAD_ATTACHMENT, "");
    }

    public String getUploadAttachmentResponse() {
        return this.buildResponseXml(UPLOAD_ATTACHMENT, "<result>Ok</result>");
    }

    public String getHeaderIn() {
        return this.buildXml(HEADER_IN, "Header In Value");
    }

    public String getHeaderInOutRequest() {
        return this.buildXml(HEADER_INOUT, "Header In Out Value");
    }

    public String getHeaderInOutResponse() {
        return this.buildXml(HEADER_INOUT, "Header In Out Value INOUT");
    }

    public String getHeaderOut() {
        return this.buildXml(HEADER_OUT, "Header In Value OUT");
    }

    public String buildXml(String operation, String value) {
        return "<con:" + operation + " xmlns:con=\"" + this.ns + "\">" + value + "</con:" + operation + ">";
    }

    private String buildResponseXml(String operation, String value) {
        return this.buildXml(operation + "Response", value);
    }
}

