/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.runtime;

import java.net.URL;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.soap.AbstractSoapServiceTestCase;
import org.mule.soap.api.SoapWebServiceConfiguration;
import org.mule.soap.api.client.SoapClientFactory;
import org.mule.soap.api.client.SoapConfigurationException;

public class SoapClientFactoryTestCase
extends AbstractSoapServiceTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private SoapClientFactory factory = SoapClientFactory.getDefault();

    @Test
    public void rpcWsdlFails() throws Exception {
        this.expectedException.expect(SoapConfigurationException.class);
        this.expectedException.expectMessage("RPC WSDLs are not supported");
        URL resource = Thread.currentThread().getContextClassLoader().getResource("wsdl/rpc.wsdl");
        this.factory.create(SoapWebServiceConfiguration.builder().withPort("SoapResponderPortType").withService("SoapResponder").withWsdlLocation(resource.getPath()).build());
    }

    @Test
    public void invalidService() throws Exception {
        this.expectedException.expect(SoapConfigurationException.class);
        this.expectedException.expectMessage("Service [INVALID_SERVICE] is not defined in the wsdl");
        URL resource = Thread.currentThread().getContextClassLoader().getResource("wsdl/simple-service.wsdl");
        this.factory.create(SoapWebServiceConfiguration.builder().withPort("INVALID PORT").withService("INVALID_SERVICE").withWsdlLocation(resource.getPath()).build());
    }

    @Test
    public void invalidPort() throws Exception {
        this.expectedException.expect(SoapConfigurationException.class);
        this.expectedException.expectMessage("Port [INVALID PORT] not found in service [TestService]");
        URL resource = Thread.currentThread().getContextClassLoader().getResource("wsdl/simple-service.wsdl");
        this.factory.create(SoapWebServiceConfiguration.builder().withPort("INVALID PORT").withService("TestService").withWsdlLocation(resource.getPath()).build());
    }
}

